/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.mansyntaxrenderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owl.model.OWLAnonymousDescription;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.OWLValueRestriction;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.mansyntaxrenderer.AbstractRenderer;
import uk.ac.manchester.cs.owl.mansyntaxrenderer.DescriptionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxObjectRenderer
extends AbstractRenderer
implements OWLObjectVisitor {
    public static final int LINE_LENGTH = 70;
    private boolean wrap = true;
    private DescriptionComparator descriptionComparator = new DescriptionComparator();

    public ManchesterOWLSyntaxObjectRenderer(Writer writer) {
        super(writer);
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    protected List<? extends OWLObject> sort(Collection<? extends OWLObject> objects) {
        ArrayList<? extends OWLObject> sortedDescriptions = new ArrayList<OWLObject>(objects);
        Collections.sort(sortedDescriptions, this.descriptionComparator);
        return sortedDescriptions;
    }

    protected void write(Set<? extends OWLObject> objects, ManchesterOWLSyntax delimeter, boolean newline) {
        int tab = this.getIndent();
        this.pushTab(tab);
        Iterator<? extends OWLObject> it = this.sort(objects).iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            if (newline && this.wrap) {
                this.writeNewLine();
            }
            this.write(delimeter);
        }
        this.popTab();
    }

    protected void write(Set<? extends OWLDescription> objects, boolean newline) {
        boolean lastWasNamed = false;
        boolean first = true;
        for (OWLObject oWLObject : this.sort(objects)) {
            if (!first) {
                if (newline) {
                    this.writeNewLine();
                }
                if (lastWasNamed && oWLObject instanceof OWLRestriction) {
                    this.write("", ManchesterOWLSyntax.THAT, " ");
                } else {
                    this.write("", ManchesterOWLSyntax.AND, " ");
                }
            }
            first = false;
            oWLObject.accept(this);
            lastWasNamed = oWLObject instanceof OWLClass;
        }
    }

    private void writeRestriction(OWLQuantifiedRestriction restriction, ManchesterOWLSyntax keyword) {
        restriction.getProperty().accept(this);
        this.write(keyword);
        if (restriction.getFiller() instanceof OWLAnonymousDescription) {
            this.write("(");
        }
        restriction.getFiller().accept(this);
        if (restriction.getFiller() instanceof OWLAnonymousDescription) {
            this.write(")");
        }
    }

    private void writeRestriction(OWLValueRestriction restriction) {
        restriction.getProperty().accept(this);
        this.write(ManchesterOWLSyntax.VALUE);
        restriction.getValue().accept(this);
    }

    private void writeRestriction(OWLCardinalityRestriction restriction, ManchesterOWLSyntax keyword) {
        restriction.getProperty().accept(this);
        this.write(keyword);
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        restriction.getFiller().accept(this);
    }

    @Override
    public void visit(OWLClass desc) {
        this.write(this.getShortFormProvider().getShortForm(desc));
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.write(desc.getOperands(), true);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.write(desc.getOperands(), ManchesterOWLSyntax.OR, true);
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.write("", ManchesterOWLSyntax.NOT, desc.isAnonymous() ? " " : "");
        if (desc.isAnonymous()) {
            this.write("(");
        }
        desc.getOperand().accept(this);
        if (desc.isAnonymous()) {
            this.write(")");
        }
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.SOME);
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.ONLY);
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.writeRestriction(desc);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MIN);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.EXACTLY);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MAX);
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.SOME);
        this.write(ManchesterOWLSyntax.SELF);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.write("{");
        this.write(desc.getIndividuals(), ManchesterOWLSyntax.ONE_OF_DELIMETER, false);
        this.write("}");
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.SOME);
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.ONLY);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.writeRestriction(desc);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MIN);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.EXACTLY);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MAX);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.write(this.getShortFormProvider().getShortForm(individual));
    }

    @Override
    public void visit(OWLDataType dataType) {
        this.write(dataType.getURI().getFragment());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(ManchesterOWLSyntax.NOT);
        node.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.write("{");
        this.write(node.getValues(), ManchesterOWLSyntax.ONE_OF_DELIMETER, false);
        this.write("}");
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        node.getDataRange().accept(this);
        this.write("[");
        this.write(node.getFacetRestrictions(), ManchesterOWLSyntax.FACET_RESTRICTION_SEPARATOR, false);
        this.write("]");
    }

    @Override
    public void visit(OWLTypedConstant node) {
        if (node.getDataType().getURI().equals(XSDVocabulary.DOUBLE.getURI())) {
            this.write(node.getLiteral());
        } else if (node.getDataType().getURI().equals(XSDVocabulary.STRING.getURI())) {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"");
        } else if (node.getDataType().getURI().equals(XSDVocabulary.FLOAT.getURI())) {
            this.write(node.getLiteral());
            this.write("f");
        } else if (node.getDataType().getURI().equals(XSDVocabulary.INT.getURI())) {
            this.write(node.getLiteral());
        } else if (node.getDataType().getURI().equals(XSDVocabulary.INTEGER.getURI())) {
            this.write(node.getLiteral());
        } else {
            this.write("\"");
            this.pushTab(this.getIndent());
            this.write(node.getLiteral(), this.wrap ? 70 : Integer.MAX_VALUE);
            this.popTab();
            this.write("\"^^");
            this.write(node.getDataType().getURI());
        }
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.write("\"");
        this.pushTab(this.getIndent());
        this.write(node.getLiteral(), this.wrap ? 70 : Integer.MAX_VALUE);
        this.popTab();
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        }
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        this.write(node.getFacet().getSymbolicForm());
        this.writeSpace();
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.write(ManchesterOWLSyntax.INVERSE);
        this.write("(");
        property.getInverse().accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        this.write(annotation.getAnnotationURI());
        this.writeSpace();
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        this.write(annotation.getAnnotationURI());
        this.writeSpace();
        ((OWLConstant)annotation.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept(this);
        this.write(ManchesterOWLSyntax.SUBCLASS_OF);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(ManchesterOWLSyntax.NOT);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    private void writePropertyCharacteristic(ManchesterOWLSyntax characteristic, OWLPropertyExpression prop) {
        this.write(characteristic);
        this.write("(");
        prop.accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.ANTI_SYMMETRIC, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.REFLEXIVE, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.write(axiom.getDescriptions(), ManchesterOWLSyntax.DISJOINT_WITH, this.wrap);
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), ManchesterOWLSyntax.EQUIVALENT_TO, this.wrap);
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(ManchesterOWLSyntax.NOT);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLConstant)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), ManchesterOWLSyntax.DIFFERENT_FROM, this.wrap);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), ManchesterOWLSyntax.DISJOINT_WITH, this.wrap);
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), ManchesterOWLSyntax.DISJOINT_WITH, this.wrap);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.RANGE);
        ((OWLDescription)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.FUNCTIONAL, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        this.write(ManchesterOWLSyntax.DISJOINT_UNION_OF);
        Iterator<OWLDescription> it = axiom.getDescriptions().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.SYMMETRIC, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.RANGE);
        ((OWLDataRange)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.FUNCTIONAL, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), ManchesterOWLSyntax.EQUIVALENT_TO, this.wrap);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.write(ManchesterOWLSyntax.TYPES);
        axiom.getDescription().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.write(axiom.getDescriptions(), ManchesterOWLSyntax.EQUIVALENT_TO, this.wrap);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLConstant)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.TRANSITIVE, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.IRREFLEXIVE, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(ManchesterOWLSyntax.INVERSE_FUNCTIONAL, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), ManchesterOWLSyntax.SAME_AS, this.wrap);
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(" o ");
        }
        this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        this.write(ManchesterOWLSyntax.INVERSE);
        axiom.getSecondProperty().accept(this);
    }

    @Override
    public void visit(SWRLRule rule) {
        Iterator<SWRLAtom> it = rule.getBody().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(" -> ");
        it = rule.getHead().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((OWLDescription)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomIObject)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((OWLDataRange)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomDObject)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.write(((SWRLBuiltInsVocabulary)((Object)node.getPredicate())).getShortName());
        this.write("(");
        Iterator<SWRLAtomDObject> it = node.getArguments().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(")");
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        this.write("?");
        this.write(node.getURI().getFragment());
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        this.write("?");
        this.write(node.getURI().getFragment());
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        node.getConstant().accept(this);
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        this.write(ManchesterOWLSyntax.SAME_AS);
        this.write("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        this.write(ManchesterOWLSyntax.DIFFERENT_FROM);
        this.write("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLOntology ontology) {
    }
}

