/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.dlsyntax;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.semanticweb.owl.io.OWLObjectRenderer;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.OWLValueRestriction;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;
import org.semanticweb.owl.util.SimpleURIShortFormProvider;
import org.semanticweb.owl.util.URIShortFormProvider;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import uk.ac.manchester.cs.owl.dlsyntax.DLSyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLSyntaxObjectRenderer
implements OWLObjectRenderer,
OWLObjectVisitor {
    private ShortFormProvider shortFormProvider = new SimpleShortFormProvider();
    private URIShortFormProvider uriShortFormProvider = new SimpleURIShortFormProvider();
    private StringBuilder buffer = new StringBuilder();
    private OWLObject focusedObject;

    public void setFocusedObject(OWLObject focusedObject) {
        this.focusedObject = focusedObject;
    }

    public boolean isFocusedObject(OWLObject obj) {
        if (this.focusedObject == null) {
            return false;
        }
        return this.focusedObject.equals(obj);
    }

    @Override
    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    @Override
    public String render(OWLObject object) {
        this.buffer = new StringBuilder();
        object.accept(this);
        return this.buffer.toString();
    }

    @Override
    public void visit(OWLOntology ontology) {
        for (OWLAxiom oWLAxiom : new TreeSet<OWLLogicalAxiom>(ontology.getLogicalAxioms())) {
            oWLAxiom.accept(this);
            this.write("\n");
        }
    }

    protected void write(String s) {
        this.buffer.append(s);
    }

    protected String renderEntity(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    protected void writeEntity(OWLEntity entity) {
        this.write(this.renderEntity(entity));
    }

    protected void write(DLSyntax keyword) {
        this.write(keyword.toString());
    }

    protected void write(int i) {
        this.write(Integer.toString(i));
    }

    protected void writeNested(OWLObject object) {
        if (this.isBracketedIfNested(object)) {
            this.write("(");
        }
        object.accept(this);
        if (this.isBracketedIfNested(object)) {
            this.write(")");
        }
    }

    protected boolean isBracketedIfNested(OWLObject object) {
        return object instanceof OWLDescription && ((OWLDescription)object).isAnonymous();
    }

    private void writeObject(OWLObject object, boolean nest) {
        if (nest) {
            this.writeNested(object);
        } else {
            object.accept(this);
        }
    }

    protected void write(Collection<? extends OWLObject> objects, DLSyntax delim, boolean nest) {
        if (objects.size() == 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject o1 = it.next();
            OWLObject o2 = it.next();
            if (this.isFocusedObject(o1) || !this.isFocusedObject(o2)) {
                this.writeObject(o1, nest);
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
                this.writeObject(o2, nest);
            } else {
                this.writeObject(o2, nest);
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
                this.writeObject(o1, nest);
            }
        } else {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                OWLObject o = it.next();
                this.writeObject(o, nest);
                if (!it.hasNext()) continue;
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
            }
        }
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept(this);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
    }

    private void writePropertyAssertion(OWLPropertyAssertionAxiom ax) {
        this.write("(");
        ax.getSubject().accept(this);
        this.write(", ");
        ax.getObject().accept(this);
        this.write(")");
        this.write(" : ");
        if (ax instanceof OWLNegativeObjectPropertyAssertionAxiom || ax instanceof OWLNegativeDataPropertyAssertionAxiom) {
            this.write(DLSyntax.NOT);
        }
        ax.getProperty().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(DLSyntax.NOT);
        this.writePropertyAssertion(axiom);
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.write(axiom.getDescriptions(), DLSyntax.DISJOINT_WITH, true);
    }

    private void writeDomainAxiom(OWLPropertyDomainAxiom axiom) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        axiom.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.writeNested(axiom.getDomain());
    }

    private void writeRestrictionSeparator() {
        this.write(".");
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeDomainAxiom(axiom);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeDomainAxiom(axiom);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.EQUIVALENT_TO, false);
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(DLSyntax.NOT);
        this.writePropertyAssertion(axiom);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), DLSyntax.NOT_EQUAL, false);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.DISJOINT_WITH, false);
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.DISJOINT_WITH, false);
    }

    private void writeRangeAxiom(OWLPropertyRangeAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.FORALL);
        this.writeSpace();
        axiom.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeRangeAxiom(axiom);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writePropertyAssertion(axiom);
    }

    private void writeFunctionalProperty(OWLPropertyExpression property) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.MAX);
        this.writeSpace();
        this.write(1);
        this.writeSpace();
        property.accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writeFunctionalProperty((OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        this.write(DLSyntax.EQUAL);
        this.write(axiom.getDescriptions(), DLSyntax.OR, false);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.EQUIVALENT_TO);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(DLSyntax.INVERSE);
    }

    private void writeSpace() {
        this.write(" ");
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeRangeAxiom(axiom);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writeFunctionalProperty((OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.EQUIVALENT_TO, false);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.write(" : ");
        axiom.getDescription().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.write(axiom.getDescriptions(), DLSyntax.EQUIVALENT_TO, false);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writePropertyAssertion(axiom);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.IN);
        this.writeSpace();
        this.write("R");
        this.write("\u207a");
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.write(DLSyntax.SUBCLASS);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.MAX);
        this.writeSpace();
        this.write(1);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), DLSyntax.EQUAL, false);
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        this.write(axiom.getPropertyChain(), DLSyntax.COMP, false);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        OWLObjectPropertyExpression second;
        OWLObjectPropertyExpression first;
        OWLObjectPropertyExpression o1 = axiom.getFirstProperty();
        OWLObjectPropertyExpression o2 = axiom.getSecondProperty();
        if (this.isFocusedObject(o1) || !this.isFocusedObject(o2)) {
            first = o1;
            second = o2;
        } else {
            first = o2;
            second = o1;
        }
        first.accept(this);
        this.writeSpace();
        this.write(DLSyntax.EQUIVALENT_TO);
        this.writeSpace();
        second.accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(SWRLRule rule) {
        this.write(rule.getHead(), DLSyntax.WEDGE, false);
        this.writeSpace();
        this.write(DLSyntax.IMPLIES);
        this.writeSpace();
        this.write(rule.getBody(), DLSyntax.WEDGE, false);
    }

    @Override
    public void visit(OWLClass desc) {
        if (desc.isOWLThing()) {
            this.write(DLSyntax.TOP);
        } else if (desc.isOWLNothing()) {
            this.write(DLSyntax.BOTTOM);
        } else {
            this.writeEntity(desc);
        }
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.write(desc.getOperands(), DLSyntax.AND, true);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.write(desc.getOperands(), DLSyntax.OR, true);
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.write(DLSyntax.NOT);
        this.writeNested(desc.getOperand());
    }

    private void writeCardinalityRestriction(OWLCardinalityRestriction restriction, DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        this.write(restriction.getCardinality());
        this.writeSpace();
        restriction.getProperty().accept(this);
        if (restriction.isQualified()) {
            this.writeRestrictionSeparator();
            this.writeNested((OWLObject)restriction.getFiller());
        }
    }

    private void writeQuantifiedRestriction(OWLQuantifiedRestriction restriction, DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        restriction.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.writeQuantifiedRestriction(desc, DLSyntax.EXISTS);
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.writeQuantifiedRestriction(desc, DLSyntax.FORALL);
    }

    private void writeValueRestriction(OWLValueRestriction restriction) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        restriction.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.write("{");
        restriction.getValue().accept(this);
        this.write("}");
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.writeValueRestriction(desc);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.writeCardinalityRestriction(desc, DLSyntax.MIN);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.writeCardinalityRestriction(desc, DLSyntax.EQUAL);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.writeCardinalityRestriction(desc, DLSyntax.MAX);
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        Iterator<OWLIndividual> it = desc.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("{");
            it.next().accept(this);
            this.write("}");
            if (!it.hasNext()) continue;
            this.write(" ");
            this.write(DLSyntax.OR);
            this.write(" ");
        }
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.writeQuantifiedRestriction(desc, DLSyntax.EXISTS);
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.writeQuantifiedRestriction(desc, DLSyntax.FORALL);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.writeValueRestriction(desc);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.writeCardinalityRestriction(desc, DLSyntax.MIN);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.writeCardinalityRestriction(desc, DLSyntax.EQUAL);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.writeCardinalityRestriction(desc, DLSyntax.MAX);
    }

    @Override
    public void visit(OWLDataType node) {
        this.write(this.shortFormProvider.getShortForm(node));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(DLSyntax.NOT);
        node.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        Iterator<OWLConstant> it = node.getValues().iterator();
        while (it.hasNext()) {
            this.write("{");
            it.next().accept(this);
            this.write("}");
            if (!it.hasNext()) continue;
            this.write(DLSyntax.OR);
        }
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.write(node.getLiteral());
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.write(node.getLiteral());
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.writeEntity(property);
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        property.getInverse().accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.writeEntity(property);
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.writeEntity(individual);
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        this.write(this.uriShortFormProvider.getShortForm(annotation.getAnnotationURI()));
        this.writeSpace();
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        this.write(this.uriShortFormProvider.getShortForm(annotation.getAnnotationURI()));
        this.writeSpace();
        ((OWLConstant)annotation.getAnnotationValue()).accept(this);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((OWLDescription)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomIObject)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((OWLDataRange)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomDObject)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        this.write("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.write(((SWRLBuiltInsVocabulary)((Object)node.getPredicate())).getShortName());
        this.write("(");
        this.write(node.getArguments(), DLSyntax.COMMA, true);
        this.write(")");
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        this.write("?");
        this.write(this.uriShortFormProvider.getShortForm(node.getURI()));
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        this.write("?");
        this.write(this.uriShortFormProvider.getShortForm(node.getURI()));
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        node.getConstant().accept(this);
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        this.write("sameAs(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        this.write("differentFrom(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.write(")");
    }
}

