/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDataVisitorEx;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDataRangeRestrictionImpl
extends OWLObjectImpl
implements OWLDataRangeRestriction {
    private OWLDataRange dataRange;
    private Set<OWLDataRangeFacetRestriction> facetRestrictions;

    public OWLDataRangeRestrictionImpl(OWLDataFactory dataFactory, OWLDataRange dataRange, Set<OWLDataRangeFacetRestriction> facetRestrictions) {
        super(dataFactory);
        this.dataRange = dataRange;
        this.facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>(facetRestrictions);
    }

    @Override
    public boolean isDataType() {
        return false;
    }

    @Override
    public OWLDataRange getDataRange() {
        return this.dataRange;
    }

    @Override
    public Set<OWLDataRangeFacetRestriction> getFacetRestrictions() {
        return Collections.unmodifiableSet(this.facetRestrictions);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLDataRangeRestriction)) {
                return false;
            }
            OWLDataRangeRestriction other = (OWLDataRangeRestriction)obj;
            return other.getDataRange().equals(this.dataRange) && ((Object)other.getFacetRestrictions()).equals(this.facetRestrictions);
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDataRangeRestriction other = (OWLDataRangeRestriction)object;
        int diff = this.dataRange.compareTo(other.getDataRange());
        if (diff != 0) {
            return diff;
        }
        return OWLDataRangeRestrictionImpl.compareSets(this.facetRestrictions, other.getFacetRestrictions());
    }
}

