/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLCompositeOntologyChange;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.OWLEntitySetProvider;
import org.semanticweb.owl.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortForm2AnnotationGenerator
implements OWLCompositeOntologyChange {
    private URI annotationURI;
    private String languageTag;
    private OWLOntologyManager ontologyManager;
    private ShortFormProvider shortFormProvider;
    private OWLEntitySetProvider<? extends OWLEntity> entitySetProvider;
    private OWLOntology ontology;

    public ShortForm2AnnotationGenerator(OWLOntologyManager ontologyManager, OWLOntology ontology, OWLEntitySetProvider<? extends OWLEntity> entitySetProvider, ShortFormProvider shortFormProvider, URI annotationURI, String languageTag) {
        this.ontologyManager = ontologyManager;
        this.shortFormProvider = shortFormProvider;
        this.entitySetProvider = entitySetProvider;
        this.ontology = ontology;
        this.annotationURI = annotationURI;
        this.languageTag = languageTag;
    }

    public ShortForm2AnnotationGenerator(OWLOntologyManager ontologyManager, OWLOntology ontology, OWLEntitySetProvider<? extends OWLEntity> entitySetProvider, ShortFormProvider shortFormProvider, URI annotationURI) {
        this(ontologyManager, ontology, entitySetProvider, shortFormProvider, annotationURI, null);
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLEntity oWLEntity : this.entitySetProvider.getEntities()) {
            String shortForm = this.shortFormProvider.getShortForm(oWLEntity);
            OWLUntypedConstant con = this.languageTag != null ? this.ontologyManager.getOWLDataFactory().getOWLUntypedConstant(shortForm, this.languageTag) : this.ontologyManager.getOWLDataFactory().getOWLUntypedConstant(shortForm);
            if (!this.ontology.containsEntityReference(oWLEntity)) continue;
            AddAxiom chg = new AddAxiom(this.ontology, this.ontologyManager.getOWLDataFactory().getOWLEntityAnnotationAxiom(oWLEntity, this.annotationURI, con));
            changes.add(chg);
        }
        return changes;
    }
}

