/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObject;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLObjectVisitor;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectDuplicator
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private OWLDataFactory dataFactory;
    private Object obj;
    private Map<OWLEntity, URI> replacementMap;

    public OWLObjectDuplicator(OWLDataFactory dataFactory) {
        this(new HashMap<OWLEntity, URI>(), dataFactory);
    }

    public OWLObjectDuplicator(OWLDataFactory dataFactory, Map<URI, URI> uriReplacementMap) {
        this.dataFactory = dataFactory;
        this.replacementMap = new HashMap<OWLEntity, URI>();
        for (URI uri : uriReplacementMap.keySet()) {
            URI repURI = uriReplacementMap.get(uri);
            this.replacementMap.put(dataFactory.getOWLClass(uri), repURI);
            this.replacementMap.put(dataFactory.getOWLObjectProperty(uri), repURI);
            this.replacementMap.put(dataFactory.getOWLDataProperty(uri), repURI);
            this.replacementMap.put(dataFactory.getOWLIndividual(uri), repURI);
        }
    }

    public OWLObjectDuplicator(Map<OWLEntity, URI> entityURIReplacementMap, OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.replacementMap = new HashMap<OWLEntity, URI>(entityURIReplacementMap);
    }

    public <O extends OWLObject> O duplicateObject(OWLObject object) {
        object.accept(this);
        return (O)((OWLObject)this.obj);
    }

    protected Object getLastObject() {
        return this.obj;
    }

    protected void setLastObject(Object obj) {
        this.obj = obj;
    }

    private URI getURI(OWLEntity entity) {
        URI replacement = this.replacementMap.get(entity);
        if (replacement != null) {
            return replacement;
        }
        return entity.getURI();
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLAntiSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
        ((OWLAxiom)axiom.getSubject()).accept(this);
        OWLAxiom subj = (OWLAxiom)this.obj;
        axiom.getAnnotation().accept(this);
        OWLAnnotation anno = (OWLAnnotation)this.obj;
        this.obj = this.dataFactory.getOWLAxiomAnnotationAxiom(subj, anno);
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        ((OWLConstant)annotation.getAnnotationValue()).accept(this);
        OWLConstant con = (OWLConstant)this.obj;
        this.obj = this.dataFactory.getOWLConstantAnnotation(annotation.getAnnotationURI(), con);
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLObjectAnnotation(annotation.getAnnotationURI(), ind);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        axiom.getDescription().accept(this);
        OWLDescription type = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLClassAssertionAxiom(ind, type);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual subj = (OWLIndividual)this.obj;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLConstant)axiom.getObject()).accept(this);
        OWLConstant con = (OWLConstant)this.obj;
        this.obj = this.dataFactory.getOWLDataPropertyAssertionAxiom(subj, prop, con);
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        axiom.getDomain().accept(this);
        OWLDescription domain = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLDataPropertyDomainAxiom(prop, domain);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)axiom.getRange()).accept(this);
        OWLDataRange range = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataPropertyRangeAxiom(prop, range);
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        OWLDataPropertyExpression subProp = (OWLDataPropertyExpression)this.obj;
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        OWLDataPropertyExpression supProp = (OWLDataPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLSubDataPropertyAxiom(subProp, supProp);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept(this);
        OWLEntity ent = (OWLEntity)this.obj;
        this.obj = this.dataFactory.getOWLDeclarationAxiom(ent);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        Set<OWLIndividual> inds = this.duplicateSet(axiom.getIndividuals());
        this.obj = this.dataFactory.getOWLDifferentIndividualsAxiom(inds);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        Set<OWLDescription> descs = this.duplicateSet(axiom.getDescriptions());
        this.obj = this.dataFactory.getOWLDisjointClassesAxiom(descs);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLDisjointDataPropertiesAxiom(props);
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(props);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        OWLClass cls = (OWLClass)this.obj;
        Set<OWLDescription> ops = this.duplicateSet(axiom.getDescriptions());
        this.obj = this.dataFactory.getOWLDisjointUnionAxiom(cls, ops);
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        ((OWLEntity)axiom.getSubject()).accept(this);
        OWLEntity entity = (OWLEntity)this.obj;
        axiom.getAnnotation().accept(this);
        OWLAnnotation anno = (OWLAnnotation)this.obj;
        this.obj = this.dataFactory.getOWLEntityAnnotationAxiom(entity, anno);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set<OWLDescription> descs = this.duplicateSet(axiom.getDescriptions());
        this.obj = this.dataFactory.getOWLEquivalentClassesAxiom(descs);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLEquivalentDataPropertiesAxiom(props);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(props);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
        axiom.getSubject().accept(this);
        OWLOntology ont = (OWLOntology)this.obj;
        URI uri = axiom.getImportedOntologyURI();
        this.obj = this.dataFactory.getOWLImportsDeclarationAxiom(ont, uri);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        OWLObjectPropertyExpression propA = (OWLObjectPropertyExpression)this.obj;
        axiom.getSecondProperty().accept(this);
        OWLObjectPropertyExpression propB = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLConstant)axiom.getObject()).accept(this);
        OWLConstant con = (OWLConstant)this.obj;
        this.obj = this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(ind, prop, con);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLIndividual)axiom.getObject()).accept(this);
        OWLIndividual ind2 = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(ind, prop, ind2);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLIndividual)axiom.getObject()).accept(this);
        OWLIndividual ind2 = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyAssertionAxiom(ind, prop, ind2);
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        axiom.getSuperProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
            p.accept(this);
            chain.add((OWLObjectPropertyExpression)this.obj);
        }
        this.obj = this.dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, prop);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        axiom.getDomain().accept(this);
        OWLDescription domain = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, domain);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLDescription)axiom.getRange()).accept(this);
        OWLDescription range = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range);
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        OWLObjectPropertyExpression subProp = (OWLObjectPropertyExpression)this.obj;
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        OWLObjectPropertyExpression supProp = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLSubObjectPropertyAxiom(subProp, supProp);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        Set<OWLIndividual> individuals = this.duplicateSet(axiom.getIndividuals());
        this.obj = this.dataFactory.getOWLSameIndividualsAxiom(individuals);
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept(this);
        OWLDescription subClass = (OWLDescription)this.obj;
        axiom.getSuperClass().accept(this);
        OWLDescription supClass = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLSubClassAxiom(subClass, supClass);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.obj);
    }

    @Override
    public void visit(OWLClass desc) {
        URI uri = this.getURI(desc);
        this.obj = this.dataFactory.getOWLClass(uri);
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataAllRestriction(prop, filler);
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataExactCardinalityRestriction(prop, desc.getCardinality(), filler);
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, desc.getCardinality(), filler);
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataMinCardinalityRestriction(prop, desc.getCardinality(), filler);
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLDataRange)desc.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataSomeRestriction(prop, filler);
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.obj;
        ((OWLConstant)desc.getValue()).accept(this);
        OWLConstant val = (OWLConstant)this.obj;
        this.obj = this.dataFactory.getOWLDataValueRestriction(prop, val);
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLDescription)desc.getFiller()).accept(this);
        OWLDescription filler = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectAllRestriction(prop, filler);
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        desc.getOperand().accept(this);
        OWLDescription op = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectComplementOf(op);
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLDescription)desc.getFiller()).accept(this);
        OWLDescription filler = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, desc.getCardinality(), filler);
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        Set<OWLDescription> ops = this.duplicateSet(desc.getOperands());
        this.obj = this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLDescription)desc.getFiller()).accept(this);
        OWLDescription filler = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, desc.getCardinality(), filler);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLDescription)desc.getFiller()).accept(this);
        OWLDescription filler = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, desc.getCardinality(), filler);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        Set<OWLIndividual> inds = this.duplicateSet(desc.getIndividuals());
        this.obj = this.dataFactory.getOWLObjectOneOf(inds);
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectSelfRestriction(prop);
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLDescription)desc.getFiller()).accept(this);
        OWLDescription filler = (OWLDescription)this.obj;
        this.obj = this.dataFactory.getOWLObjectSomeRestriction(prop, filler);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        Set<OWLDescription> ops = this.duplicateSet(desc.getOperands());
        this.obj = this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        ((OWLIndividual)desc.getValue()).accept(this);
        OWLIndividual value = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getOWLObjectValueRestriction(prop, value);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        node.getDataRange().accept(this);
        OWLDataRange dr = (OWLDataRange)this.obj;
        this.obj = this.dataFactory.getOWLDataComplementOf(dr);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        Set<OWLConstant> vals = this.duplicateSet(node.getValues());
        this.obj = this.dataFactory.getOWLDataOneOf(vals);
    }

    @Override
    public void visit(OWLDataType node) {
        URI uri = node.getURI();
        this.obj = this.dataFactory.getOWLDataType(uri);
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        node.getDataRange().accept(this);
        OWLDataRange dr = (OWLDataRange)this.obj;
        HashSet<OWLDataRangeFacetRestriction> restrictions = new HashSet<OWLDataRangeFacetRestriction>();
        for (OWLDataRangeFacetRestriction restriction : node.getFacetRestrictions()) {
            restriction.accept(this);
            restrictions.add((OWLDataRangeFacetRestriction)this.obj);
        }
        this.obj = this.dataFactory.getOWLDataRangeRestriction(dr, restrictions);
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        node.getFacetValue().accept(this);
        OWLTypedConstant val = (OWLTypedConstant)this.obj;
        this.obj = this.dataFactory.getOWLDataRangeFacetRestriction(node.getFacet(), val);
    }

    @Override
    public void visit(OWLTypedConstant node) {
        node.getDataType().accept(this);
        OWLDataType dt = (OWLDataType)this.obj;
        this.obj = this.dataFactory.getOWLTypedConstant(node.getLiteral(), dt);
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.obj = this.dataFactory.getOWLUntypedConstant(node.getLiteral(), node.getLang());
    }

    @Override
    public void visit(OWLDataProperty property) {
        URI uri = this.getURI(property);
        this.obj = this.dataFactory.getOWLDataProperty(uri);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        URI uri = this.getURI(property);
        this.obj = this.dataFactory.getOWLObjectProperty(uri);
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        property.getInverse().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.dataFactory.getOWLObjectPropertyInverse(prop);
    }

    @Override
    public void visit(OWLIndividual individual) {
        URI uri = this.getURI(individual);
        this.obj = this.dataFactory.getOWLIndividual(uri);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.obj = ontology;
    }

    @Override
    public void visit(SWRLRule rule) {
        HashSet<SWRLAtom> antecedents = new HashSet<SWRLAtom>();
        HashSet<SWRLAtom> consequents = new HashSet<SWRLAtom>();
        for (SWRLAtom atom : rule.getBody()) {
            atom.accept(this);
            antecedents.add((SWRLAtom)this.obj);
        }
        for (SWRLAtom atom : rule.getHead()) {
            atom.accept(this);
            consequents.add((SWRLAtom)this.obj);
        }
        this.obj = this.dataFactory.getSWRLRule(rule.getURI(), antecedents, consequents);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((OWLDescription)node.getPredicate()).accept(this);
        OWLDescription desc = (OWLDescription)this.obj;
        ((SWRLAtomIObject)node.getArgument()).accept(this);
        SWRLAtomIObject atom = (SWRLAtomIObject)this.obj;
        this.obj = this.dataFactory.getSWRLClassAtom(desc, atom);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((OWLDataRange)node.getPredicate()).accept(this);
        OWLDataRange rng = (OWLDataRange)this.obj;
        ((SWRLAtomDObject)node.getArgument()).accept(this);
        SWRLAtomDObject atom = (SWRLAtomDObject)this.obj;
        this.obj = this.dataFactory.getSWRLDataRangeAtom(rng, atom);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        OWLObjectPropertyExpression exp = (OWLObjectPropertyExpression)this.obj;
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        SWRLAtomIObject arg0 = (SWRLAtomIObject)this.obj;
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        SWRLAtomIObject arg1 = (SWRLAtomIObject)this.obj;
        this.obj = this.dataFactory.getSWRLObjectPropertyAtom(exp, arg0, arg1);
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        OWLDataPropertyExpression exp = (OWLDataPropertyExpression)this.obj;
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        SWRLAtomIObject arg0 = (SWRLAtomIObject)this.obj;
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
        SWRLAtomDObject arg1 = (SWRLAtomDObject)this.obj;
        this.obj = this.dataFactory.getSWRLDataValuedPropertyAtom(exp, arg0, arg1);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        ArrayList<SWRLAtomDObject> atomObjects = new ArrayList<SWRLAtomDObject>();
        for (SWRLAtomDObject atomObject : node.getArguments()) {
            atomObject.accept(this);
            atomObjects.add((SWRLAtomDObject)this.obj);
        }
        this.obj = this.dataFactory.getSWRLBuiltInAtom((SWRLBuiltInsVocabulary)((Object)node.getPredicate()), atomObjects);
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        SWRLAtomIObject arg0 = (SWRLAtomIObject)this.obj;
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        SWRLAtomIObject arg1 = (SWRLAtomIObject)this.obj;
        this.obj = this.dataFactory.getSWRLDifferentFromAtom(arg0, arg1);
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        SWRLAtomIObject arg0 = (SWRLAtomIObject)this.obj;
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        SWRLAtomIObject arg1 = (SWRLAtomIObject)this.obj;
        this.obj = this.dataFactory.getSWRLSameAsAtom(arg0, arg1);
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        this.obj = this.dataFactory.getSWRLAtomDVariable(node.getURI());
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        this.obj = this.dataFactory.getSWRLAtomIVariable(node.getURI());
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        node.getIndividual().accept(this);
        OWLIndividual ind = (OWLIndividual)this.obj;
        this.obj = this.dataFactory.getSWRLAtomIndividualObject(ind);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        node.getConstant().accept(this);
        OWLConstant con = (OWLConstant)this.obj;
        this.obj = this.dataFactory.getSWRLAtomConstantObject(con);
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
        axiom.getAnnotation().accept(this);
        OWLAnnotation anno = (OWLAnnotation)this.obj;
        this.obj = this.dataFactory.getOWLOntologyAnnotationAxiom((OWLOntology)axiom.getSubject(), anno);
    }

    private <O extends OWLObject> Set<O> duplicateSet(Set<O> objs) {
        HashSet<OWLObject> dup = new HashSet<OWLObject>();
        for (OWLObject o : objs) {
            o.accept(this);
            dup.add((OWLObject)this.obj);
        }
        return dup;
    }

    private <O extends SWRLObject> Set<O> duplicateSWRLObjectSet(Set<O> objs) {
        HashSet<SWRLObject> dup = new HashSet<SWRLObject>();
        for (SWRLObject o : objs) {
            o.accept(this);
            dup.add((SWRLObject)this.obj);
        }
        return dup;
    }
}

