/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.normalform;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.normalform.NormalFormRewriter;
import org.semanticweb.owl.normalform.OWLObjectComplementOfExtractor;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;
import uk.ac.manchester.cs.owl.OWLDataFactoryImpl;

public class NegationalNormalFormConverter
implements NormalFormRewriter {
    private OWLDataFactory dataFactory;
    private OWLObjectComplementOfExtractor extractor;

    public NegationalNormalFormConverter(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.extractor = new OWLObjectComplementOfExtractor();
    }

    public boolean isInNormalForm(OWLDescription description) {
        this.extractor.getComplementedDescriptions(description);
        for (OWLDescription desc : this.extractor.getComplementedDescriptions(description)) {
            if (!desc.isAnonymous()) continue;
            return false;
        }
        return true;
    }

    public OWLDescription convertToNormalForm(OWLDescription description) {
        return this.seekNegatedDescriptions(description);
    }

    private OWLDescription seekNegatedDescriptions(OWLDescription description) {
        NegatedDescriptionSeeker seeker = new NegatedDescriptionSeeker();
        return seeker.process(description);
    }

    private OWLDescription convertNegatedDescription(OWLDescription description) {
        OWLDescriptionConverter converter = new OWLDescriptionConverter();
        return converter.convert(description);
    }

    public static void main(String[] args) {
        OWLDataFactoryImpl df = new OWLDataFactoryImpl();
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        ops.add(df.getOWLClass(URI.create("A")));
        ops.add(df.getOWLObjectSomeRestriction(df.getOWLObjectProperty(URI.create("p")), df.getOWLClass(URI.create("B"))));
        OWLObjectIntersectionOf d = df.getOWLObjectIntersectionOf(ops);
        OWLObjectComplementOf negD = df.getOWLObjectComplementOf(d);
        NegationalNormalFormConverter converter = new NegationalNormalFormConverter(df);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 5000000; ++i) {
            converter.convertToNormalForm(negD);
        }
        long t1 = System.currentTimeMillis();
        System.out.println(t1 - t0);
    }

    private class OWLDescriptionConverter
    extends OWLDescriptionVisitorAdapter {
        private OWLDescription result;

        private OWLDescriptionConverter() {
        }

        public OWLDescription convert(OWLDescription desc) {
            this.result = null;
            desc.accept(this);
            if (this.result == null) {
                return NegationalNormalFormConverter.this.dataFactory.getOWLObjectComplementOf(desc);
            }
            return this.result;
        }

        public void visit(OWLDataExactCardinalityRestriction desc) {
            OWLDataPropertyExpression prop = (OWLDataPropertyExpression)desc.getProperty();
            int cardinality = desc.getCardinality();
            HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
            OWLDataMinCardinalityRestriction minCard = NegationalNormalFormConverter.this.dataFactory.getOWLDataMinCardinalityRestriction(prop, cardinality, (OWLDataRange)desc.getFiller());
            OWLDataMaxCardinalityRestriction maxCard = NegationalNormalFormConverter.this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, cardinality, (OWLDataRange)desc.getFiller());
            ops.add(NegationalNormalFormConverter.this.convertNegatedDescription(minCard));
            ops.add(NegationalNormalFormConverter.this.convertNegatedDescription(maxCard));
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectUnionOf(ops);
        }

        public void visit(OWLDataMaxCardinalityRestriction desc) {
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLDataMinCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), desc.getCardinality() + 1, (OWLDataRange)desc.getFiller());
        }

        public void visit(OWLDataMinCardinalityRestriction desc) {
            int card = desc.getCardinality();
            this.result = card != 0 ? NegationalNormalFormConverter.this.dataFactory.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)desc.getProperty(), --card, (OWLDataRange)desc.getFiller()) : NegationalNormalFormConverter.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectAllRestriction desc) {
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)desc.getProperty(), NegationalNormalFormConverter.this.convertNegatedDescription((OWLDescription)desc.getFiller()));
        }

        public void visit(OWLObjectComplementOf desc) {
            this.result = NegationalNormalFormConverter.this.seekNegatedDescriptions(desc.getOperand());
        }

        public void visit(OWLObjectExactCardinalityRestriction desc) {
            OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)desc.getProperty();
            int cardinality = desc.getCardinality();
            HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
            OWLObjectMinCardinalityRestriction minCard = NegationalNormalFormConverter.this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, cardinality, (OWLDescription)desc.getFiller());
            OWLObjectMaxCardinalityRestriction maxCard = NegationalNormalFormConverter.this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, cardinality, (OWLDescription)desc.getFiller());
            ops.add(NegationalNormalFormConverter.this.convertNegatedDescription(minCard));
            ops.add(NegationalNormalFormConverter.this.convertNegatedDescription(maxCard));
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectUnionOf(ops);
        }

        public void visit(OWLObjectIntersectionOf desc) {
            HashSet<OWLDescription> opsnew = new HashSet<OWLDescription>();
            for (OWLDescription op : desc.getOperands()) {
                opsnew.add(NegationalNormalFormConverter.this.convertNegatedDescription(op));
            }
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectUnionOf(opsnew);
        }

        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality() + 1, NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller()));
        }

        public void visit(OWLObjectMinCardinalityRestriction desc) {
            int card = desc.getCardinality();
            this.result = card != 0 ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), --card, NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller())) : NegationalNormalFormConverter.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectSomeRestriction desc) {
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), NegationalNormalFormConverter.this.convertNegatedDescription((OWLDescription)desc.getFiller()));
        }

        public void visit(OWLObjectUnionOf desc) {
            HashSet<OWLDescription> opsnew = new HashSet<OWLDescription>();
            boolean changed = false;
            for (OWLDescription op : desc.getOperands()) {
                OWLDescription opnew = NegationalNormalFormConverter.this.convertNegatedDescription(op);
                if (!opnew.equals(op)) {
                    changed = true;
                }
                opsnew.add(op);
            }
            this.result = changed ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectIntersectionOf(opsnew) : desc;
        }

        public void visit(OWLObjectValueRestriction desc) {
            OWLObjectComplementOf filler = NegationalNormalFormConverter.this.dataFactory.getOWLObjectComplementOf(NegationalNormalFormConverter.this.dataFactory.getOWLObjectOneOf(Collections.singleton(desc.getValue())));
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }

        public void visit(OWLObjectOneOf desc) {
            HashSet<OWLObjectComplementOf> ops = new HashSet<OWLObjectComplementOf>();
            for (OWLIndividual ind : desc.getIndividuals()) {
                OWLObjectOneOf singleton = NegationalNormalFormConverter.this.dataFactory.getOWLObjectOneOf(Collections.singleton(ind));
                ops.add(NegationalNormalFormConverter.this.dataFactory.getOWLObjectComplementOf(singleton));
            }
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
    }

    private class NegatedDescriptionSeeker
    extends OWLDescriptionVisitorAdapter {
        private OWLDescription result;

        private NegatedDescriptionSeeker() {
        }

        public OWLDescription process(OWLDescription desc) {
            this.result = desc;
            desc.accept(this);
            return this.result;
        }

        public void visit(OWLObjectAllRestriction desc) {
            OWLDescription filler = NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller());
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }

        public void visit(OWLObjectComplementOf desc) {
            this.result = NegationalNormalFormConverter.this.convertNegatedDescription(desc.getOperand());
        }

        public void visit(OWLObjectExactCardinalityRestriction desc) {
            OWLDescription filler = NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller());
            this.result = NegationalNormalFormConverter.this.dataFactory.getOWLObjectExactCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality(), filler);
        }

        public void visit(OWLObjectIntersectionOf desc) {
            HashSet<OWLDescription> opsnew = new HashSet<OWLDescription>();
            boolean changed = false;
            for (OWLDescription op : desc.getOperands()) {
                OWLDescription opnew = NegationalNormalFormConverter.this.seekNegatedDescriptions(op);
                opsnew.add(opnew);
                if (op.equals(opnew)) continue;
                changed = true;
            }
            this.result = changed ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectIntersectionOf(opsnew) : desc;
        }

        public void visit(OWLObjectMaxCardinalityRestriction desc) {
            OWLDescription filler = NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller());
            this.result = !filler.equals(desc.getFiller()) ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality(), filler) : desc;
        }

        public void visit(OWLObjectMinCardinalityRestriction desc) {
            OWLDescription filler = NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller());
            this.result = !filler.equals(desc.getFiller()) ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality(), filler) : desc;
        }

        public void visit(OWLObjectSomeRestriction desc) {
            OWLDescription filler = NegationalNormalFormConverter.this.seekNegatedDescriptions((OWLDescription)desc.getFiller());
            this.result = !filler.equals(desc.getFiller()) ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)desc.getProperty(), filler) : desc;
        }

        public void visit(OWLObjectUnionOf desc) {
            HashSet<OWLDescription> opsnew = new HashSet<OWLDescription>();
            boolean changed = false;
            for (OWLDescription op : desc.getOperands()) {
                OWLDescription opnew = NegationalNormalFormConverter.this.seekNegatedDescriptions(op);
                opsnew.add(opnew);
                if (op.equals(opnew)) continue;
                changed = true;
            }
            this.result = changed ? NegationalNormalFormConverter.this.dataFactory.getOWLObjectUnionOf(opsnew) : desc;
        }
    }
}

