/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.metrics;

import java.util.HashSet;
import java.util.List;
import org.semanticweb.owl.metrics.IntegerValuedMetric;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.NamedConjunctChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOfClassesWithMultipleInheritance
extends IntegerValuedMetric {
    public NumberOfClassesWithMultipleInheritance(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    public String getName() {
        return "Number of classes with asserted multiple inheritance";
    }

    @Override
    public Integer recomputeMetric() {
        HashSet<OWLClass> processed = new HashSet<OWLClass>();
        HashSet<OWLClass> clses = new HashSet<OWLClass>();
        NamedConjunctChecker checker = new NamedConjunctChecker();
        for (OWLOntology ont : this.getOntologies()) {
            block1: for (OWLClass cls : ont.getReferencedClasses()) {
                if (processed.contains(cls)) continue;
                processed.add(cls);
                int count = 0;
                for (OWLDescription sup : cls.getSubClasses(this.getOntologies())) {
                    if (checker.hasNamedConjunct(sup)) {
                        ++count;
                    }
                    if (count <= 1) continue;
                    clses.add(cls);
                    continue block1;
                }
            }
        }
        return clses.size();
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMetric() {
    }
}

