/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.metrics;

import java.util.HashSet;
import java.util.List;
import org.semanticweb.owl.metrics.IntegerValuedMetric;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaximumNumberOfNamedSuperclasses
extends IntegerValuedMetric {
    public MaximumNumberOfNamedSuperclasses(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    public String getName() {
        return "Maximum number of asserted named superclasses";
    }

    @Override
    public Integer recomputeMetric() {
        int count = 0;
        HashSet<OWLClass> processedClasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLClass cls : ont.getReferencedClasses()) {
                if (processedClasses.contains(cls)) continue;
                processedClasses.add(cls);
                int curCount = 0;
                for (OWLDescription desc : cls.getSuperClasses(ont)) {
                    if (desc.isAnonymous()) continue;
                    ++curCount;
                }
                if (curCount <= count) continue;
                count = curCount;
            }
        }
        return count;
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMetric() {
    }
}

