/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLOntologyInputSourceException;

public class FileInputSource
implements OWLOntologyInputSource {
    private File file;

    public FileInputSource(File file) {
        this.file = file;
    }

    public URI getPhysicalURI() {
        return this.file.toURI();
    }

    public boolean isInputStreamAvailable() {
        return true;
    }

    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    public boolean isReaderAvailable() {
        return true;
    }

    public Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }
}

