/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomChange;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLReasonerAdapter
implements OWLReasoner,
OWLOntologyChangeListener {
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;

    protected OWLReasonerAdapter(OWLOntologyManager manager) {
        this.manager = manager;
        this.ontologies = new HashSet<OWLOntology>();
        manager.addOntologyChangeListener(this);
    }

    @Override
    public final void dispose() {
        this.manager.removeOntologyChangeListener(this);
        this.disposeReasoner();
    }

    protected abstract void disposeReasoner();

    protected OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    protected OWLDataFactory getOWLDataFactory() {
        return this.manager.getOWLDataFactory();
    }

    @Override
    public void loadOntologies(Set<OWLOntology> ontologies) throws OWLReasonerException {
        this.ontologies.addAll(ontologies);
        this.ontologiesChanged();
    }

    @Override
    public Set<OWLOntology> getLoadedOntologies() {
        return Collections.unmodifiableSet(this.ontologies);
    }

    @Override
    public void unloadOntologies(Set<OWLOntology> ontologies) throws OWLReasonerException {
        this.ontologies.removeAll(ontologies);
        this.ontologiesChanged();
    }

    @Override
    public void clearOntologies() throws OWLReasonerException {
        this.ontologies.clear();
        this.ontologiesCleared();
    }

    protected abstract void ontologiesCleared() throws OWLReasonerException;

    protected abstract void ontologiesChanged() throws OWLReasonerException;

    protected Set<OWLAxiom> getAllAxioms() {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLOntology ont : this.ontologies) {
            result.addAll(ont.getLogicalAxioms());
        }
        return result;
    }

    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        ArrayList<OWLAxiomChange> filteredChanges = null;
        for (OWLOntologyChange oWLOntologyChange : changes) {
            OWLAxiomChange axiomChange;
            if (!this.ontologies.contains(oWLOntologyChange.getOntology()) || !oWLOntologyChange.isAxiomChange() || !(axiomChange = (OWLAxiomChange)oWLOntologyChange).getAxiom().isLogicalAxiom()) continue;
            if (filteredChanges == null) {
                filteredChanges = new ArrayList<OWLAxiomChange>();
            }
            filteredChanges.add(axiomChange);
        }
        if (filteredChanges != null) {
            this.handleOntologyChanges(filteredChanges);
        }
    }

    protected abstract void handleOntologyChanges(List<OWLOntologyChange> var1) throws OWLException;

    public static <E> Set<E> flattenSetOfSets(Set<Set<E>> setOfSets) {
        HashSet<E> result = new HashSet<E>();
        for (Set<E> set : setOfSets) {
            result.addAll(set);
        }
        return result;
    }

    public static <O> Set<Set<O>> createSetOfSets(Collection<O> objs, Map<O, Collection<O>> equivalentsMap) {
        Set<Set<O>> result = CollectionFactory.createSet();
        for (O obj : objs) {
            Set equivalentResultSet = CollectionFactory.createSet();
            Collection<O> equivalents = equivalentsMap.get(obj);
            if (equivalents != null) {
                equivalentResultSet.addAll(equivalents);
            }
            equivalentResultSet.add(obj);
            result.add(equivalentResultSet);
        }
        return result;
    }
}

