/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.debugging;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.CollectionFactory;

public class DebuggerDescriptionGenerator
implements OWLAxiomVisitor {
    private OWLDataFactory dataFactory;
    private OWLDescription desc;

    public DebuggerDescriptionGenerator(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public OWLDescription getDebuggerDescription() {
        return this.desc;
    }

    public void visit(OWLSubClassAxiom axiom) {
        OWLObjectComplementOf complement = this.dataFactory.getOWLObjectComplementOf(axiom.getSuperClass());
        this.desc = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(axiom.getSubClass(), complement));
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        OWLDataSomeRestriction sub = this.dataFactory.getOWLDataSomeRestriction((OWLDataPropertyExpression)axiom.getProperty(), this.dataFactory.getTopDataType());
        OWLSubClassAxiom ax = this.dataFactory.getOWLSubClassAxiom(sub, axiom.getDomain());
        ax.accept(this);
    }

    public void visit(OWLImportsDeclaration axiom) {
    }

    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectSomeRestriction sub = this.dataFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)axiom.getProperty(), this.dataFactory.getOWLThing());
        OWLSubClassAxiom ax = this.dataFactory.getOWLSubClassAxiom(sub, axiom.getDomain());
        ax.accept(this);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLObjectAllRestriction sup = this.dataFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLDescription)axiom.getRange());
        OWLSubClassAxiom ax = this.dataFactory.getOWLSubClassAxiom(this.dataFactory.getOWLThing(), sup);
        ax.accept(this);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    public void visit(OWLObjectSubPropertyAxiom axiom) {
        OWLIndividual ind = this.dataFactory.getOWLIndividual(URI.create("http://debugger.com#" + System.nanoTime()));
        OWLObjectValueRestriction sub = this.dataFactory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)axiom.getSubProperty(), ind);
        OWLObjectValueRestriction sup = this.dataFactory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)axiom.getSuperProperty(), ind);
        OWLSubClassAxiom ax = this.dataFactory.getOWLSubClassAxiom(sub, sup);
        ax.accept(this);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.dataFactory.getOWLObjectOneOf(Collections.singleton(axiom.getIndividual()));
        OWLSubClassAxiom ax = this.dataFactory.getOWLSubClassAxiom(sub, axiom.getDescription());
        ax.accept(this);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getDescriptions().size() == 2 && axiom.getDescriptions().contains(this.dataFactory.getOWLNothing())) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                if (desc.isOWLNothing()) continue;
                this.desc = desc;
                return;
            }
        }
        Set<OWLDescription> clses = axiom.getDescriptions();
        Iterator<OWLDescription> it = clses.iterator();
        OWLDescription descC = it.next();
        OWLObjectComplementOf notC = this.dataFactory.getOWLObjectComplementOf(descC);
        OWLDescription descD = it.next();
        OWLObjectComplementOf notD = this.dataFactory.getOWLObjectComplementOf(descD);
        OWLObjectIntersectionOf left = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(descC, notD));
        OWLObjectIntersectionOf right = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(notC, descD));
        this.desc = this.dataFactory.getOWLObjectUnionOf(CollectionFactory.createSet(left, right));
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLDataSubPropertyAxiom axiom) {
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    public void visit(OWLSameIndividualsAxiom axiom) {
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    public void visit(SWRLRule rule) {
    }
}

