/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmalgamateSubClassAxioms
extends AbstractCompositeOntologyChange {
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public AmalgamateSubClassAxioms(Set<OWLOntology> ontologies, OWLDataFactory dataFactory) {
        super(dataFactory);
        for (OWLOntology ont : ontologies) {
            for (OWLClass cls : ont.getReferencedClasses()) {
                Set<OWLSubClassAxiom> axioms = ont.getSubClassAxiomsForLHS(cls);
                if (axioms.size() <= 1) continue;
                HashSet<OWLDescription> superClasses = new HashSet<OWLDescription>();
                for (OWLSubClassAxiom ax : axioms) {
                    this.changes.add(new RemoveAxiom(ont, ax));
                    superClasses.add(ax.getSuperClass());
                }
                OWLObjectIntersectionOf combinedSuperClass = this.getDataFactory().getOWLObjectIntersectionOf(superClasses);
                this.changes.add(new AddAxiom(ont, this.getDataFactory().getOWLSubClassAxiom(cls, combinedSuperClass)));
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

