/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddClassDescriptionClosureAxiom
extends AbstractCompositeOntologyChange {
    private OWLClass cls;
    private OWLObjectPropertyExpression property;
    private Set<OWLOntology> ontologies;
    private OWLOntology targetOntology;
    private List<OWLOntologyChange> changes;

    public AddClassDescriptionClosureAxiom(OWLDataFactory dataFactory, OWLClass cls, OWLObjectPropertyExpression property, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        super(dataFactory);
        this.cls = cls;
        this.property = property;
        this.ontologies = ontologies;
        this.targetOntology = targetOntology;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        FillerCollector collector = new FillerCollector();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubClassAxiom ax : ont.getSubClassAxiomsForLHS(this.cls)) {
                ax.getSuperClass().accept(collector);
            }
        }
        Set<OWLDescription> fillers = collector.getFillers();
        if (fillers.isEmpty()) {
            return;
        }
        OWLObjectUnionOf closureAxiomFiller = this.getDataFactory().getOWLObjectUnionOf(fillers);
        OWLObjectAllRestriction closureAxiomDesc = this.getDataFactory().getOWLObjectAllRestriction(this.property, closureAxiomFiller);
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLSubClassAxiom(this.cls, closureAxiomDesc)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FillerCollector
    extends OWLDescriptionVisitorAdapter {
        private Set<OWLDescription> fillers = new HashSet<OWLDescription>();

        public Set<OWLDescription> getFillers() {
            return this.fillers;
        }

        public void reset() {
            this.fillers.clear();
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            if (((OWLObjectPropertyExpression)desc.getProperty()).equals(AddClassDescriptionClosureAxiom.this.property)) {
                this.fillers.add((OWLDescription)desc.getFiller());
            }
        }

        @Override
        public void visit(OWLObjectValueRestriction desc) {
            if (((OWLObjectPropertyExpression)desc.getProperty()).equals(AddClassDescriptionClosureAxiom.this.property)) {
                this.fillers.add(AddClassDescriptionClosureAxiom.this.getDataFactory().getOWLObjectOneOf(CollectionFactory.createSet((OWLIndividual)desc.getValue())));
            }
        }
    }
}

