/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxml.renderer;

import java.util.Set;
import org.coode.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.OWLXMLVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLXMLObjectRenderer
implements OWLObjectVisitor {
    private OWLXMLWriter writer;
    private OWLOntology ontology;

    public OWLXMLObjectRenderer(OWLOntology ontology, OWLXMLWriter writer) {
        this.writer = writer;
        this.ontology = ontology;
    }

    public OWLXMLObjectRenderer(OWLXMLWriter writer) {
        this.writer = writer;
        this.ontology = null;
    }

    private void writeAnnotations(OWLAxiom axiom) {
        if (this.ontology != null) {
            for (OWLAxiomAnnotationAxiom ax : axiom.getAnnotationAxioms(this.ontology)) {
                ax.accept(this);
            }
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        for (OWLImportsDeclaration oWLImportsDeclaration : ontology.getImportsDeclarations()) {
            oWLImportsDeclaration.accept(this);
        }
        for (OWLOntologyAnnotationAxiom oWLOntologyAnnotationAxiom : ontology.getAnnotations(ontology)) {
            oWLOntologyAnnotationAxiom.accept(this);
        }
        for (OWLAxiom oWLAxiom : ontology.getAxioms()) {
            if (oWLAxiom instanceof OWLAxiomAnnotationAxiom || oWLAxiom instanceof OWLOntologyAnnotationAxiom) continue;
            oWLAxiom.accept(this);
        }
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION.getURI());
        this.writer.writeAnnotationURIAttribute(annotation.getAnnotationURI());
        this.writer.writeStartElement(OWLXMLVocabulary.CONSTANT.getURI());
        if (((OWLConstant)annotation.getAnnotationValue()).isTyped()) {
            this.writer.writeDatatypeAttribute(((OWLTypedConstant)annotation.getAnnotationValue()).getDataType().getURI());
        }
        this.writer.writeTextContent(((OWLConstant)annotation.getAnnotationValue()).getLiteral());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION.getURI());
        this.writer.writeAnnotationURIAttribute(annotation.getAnnotationURI());
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANTI_SYMMETRIC_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS_ASSERTION.getURI());
        this.writeAnnotations(axiom);
        axiom.getDescription().accept(this);
        axiom.getIndividual().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION.getURI());
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLConstant)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeAnnotations(axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN.getURI());
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getDomain().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeAnnotations(axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_RANGE.getURI());
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.writeAnnotations(axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF.getURI());
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.writeAnnotations(axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.DECLARATION.getURI());
        this.writeAnnotations(axiom);
        axiom.getEntity().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getIndividuals());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_CLASSES.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getDescriptions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_UNION.getURI());
        this.writeAnnotations(axiom);
        axiom.getOWLClass().accept(this);
        this.writer.writeStartElement(OWLXMLVocabulary.UNION_OF.getURI());
        this.render(axiom.getDescriptions());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ENTITY_ANNOTATION.getURI());
        this.writeAnnotations(axiom);
        ((OWLEntity)axiom.getSubject()).accept(this);
        axiom.getAnnotation().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_CLASSES.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getDescriptions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.IMPORTS.getURI());
        this.writeAnnotations(axiom);
        this.writer.writeTextContent(axiom.getImportedOntologyURI().toString());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES.getURI());
        this.writeAnnotations(axiom);
        axiom.getFirstProperty().accept(this);
        axiom.getSecondProperty().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION.getURI());
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLConstant)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF.getURI());
        this.writeAnnotations(axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_CHAIN.getURI());
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        this.writer.writeEndElement();
        axiom.getSuperProperty().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN.getURI());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getDomain().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLDescription)axiom.getRange()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SAME_INDIVIDUALS.getURI());
        this.writeAnnotations(axiom);
        this.render(axiom.getIndividuals());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_CLASS_OF.getURI());
        this.writeAnnotations(axiom);
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY.getURI());
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLClass desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS.getURI());
        this.writer.writeNameAttribute(desc.getURI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_ALL_VALUES_FROM.getURI());
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_EXACT_CARDINALITY.getURI());
        this.writer.writeCardinalityAttribute(desc.getCardinality());
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        if (desc.isQualified()) {
            ((OWLDataRange)desc.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_MAX_CARDINALITY.getURI());
        this.writer.writeCardinalityAttribute(desc.getCardinality());
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        if (desc.isQualified()) {
            ((OWLDataRange)desc.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_MIN_CARDINALITY.getURI());
        this.writer.writeCardinalityAttribute(desc.getCardinality());
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        if (desc.isQualified()) {
            ((OWLDataRange)desc.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_SOME_VALUES_FROM.getURI());
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_HAS_VALUE.getURI());
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        ((OWLConstant)desc.getValue()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM.getURI());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF.getURI());
        desc.getOperand().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY.getURI());
        this.writer.writeCardinalityAttribute(desc.getCardinality());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        if (desc.isQualified()) {
            ((OWLDescription)desc.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_INTERSECTION_OF.getURI());
        this.render(desc.getOperands());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY.getURI());
        this.writer.writeCardinalityAttribute(desc.getCardinality());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        if (desc.isQualified()) {
            ((OWLDescription)desc.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY.getURI());
        this.writer.writeCardinalityAttribute(desc.getCardinality());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        if (desc.isQualified()) {
            ((OWLDescription)desc.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_ONE_OF.getURI());
        this.render(desc.getIndividuals());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_EXISTS_SELF.getURI());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM.getURI());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_UNION_OF.getURI());
        this.render(desc.getOperands());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_HAS_VALUE.getURI());
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLIndividual)desc.getValue()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_COMPLEMENT_OF.getURI());
        node.getDataRange().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_ONE_OF.getURI());
        this.render(node.getValues());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataType node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE.getURI());
        this.writer.writeNameAttribute(node.getURI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE_RESTRICTION.getURI());
        node.getDataRange().accept(this);
        for (OWLDataRangeFacetRestriction restriction : node.getFacetRestrictions()) {
            restriction.accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE_FACET_RESTRICTION.getURI());
        this.writer.writeFacetAttribute(node.getFacet().getURI());
        node.getFacetValue().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.writer.writeStartElement(OWLXMLVocabulary.CONSTANT.getURI());
        this.writer.writeDatatypeAttribute(node.getDataType().getURI());
        this.writer.writeTextContent(node.getLiteral());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.writer.writeStartElement(OWLXMLVocabulary.CONSTANT.getURI());
        this.writer.writeTextContent(node.getLiteral());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY.getURI());
        this.writer.writeNameAttribute(property.getURI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY.getURI());
        this.writer.writeNameAttribute(property.getURI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTY.getURI());
        property.getInverse().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.writer.writeStartElement(OWLXMLVocabulary.INDIVIDUAL.getURI());
        this.writer.writeNameAttribute(individual.getURI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(SWRLRule rule) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLClassAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    private void render(Set<? extends OWLObject> objects) {
        for (OWLObject oWLObject : objects) {
            oWLObject.accept(this);
        }
    }
}

