/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPImportsHandler
extends TriplePredicateHandler {
    private Set<URI> schemaImportsURIs = new HashSet<URI>();

    public TPImportsHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_IMPORTS.getURI());
        for (Namespaces n : Namespaces.values()) {
            String ns = n.toString();
            this.schemaImportsURIs.add(URI.create(ns.substring(0, ns.length() - 1)));
        }
        this.schemaImportsURIs.add(URI.create("http://www.daml.org/rules/proposal/swrlb.owl"));
        this.schemaImportsURIs.add(URI.create("http://www.daml.org/rules/proposal/swrl.owl"));
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return true;
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        this.consumeTriple(subject, predicate, object);
        this.getConsumer().addOntology(subject);
        this.getConsumer().addOntology(object);
        if (!this.schemaImportsURIs.contains(object)) {
            OWLImportsDeclaration importsDeclaration = this.getDataFactory().getOWLImportsDeclarationAxiom(this.getConsumer().getOntology(), object);
            this.addAxiom(importsDeclaration);
            OWLOntologyManager man = this.getConsumer().getOWLOntologyManager();
            man.makeLoadImportRequest(importsDeclaration);
            this.getConsumer().importsClosureChanged();
        }
    }
}

