/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdf.rdfxml;

import java.io.IOException;
import java.net.URI;
import org.coode.xml.XMLWriter;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.vocab.Namespaces;

public class RDFXMLWriter {
    private XMLWriter writer;

    RDFXMLWriter(XMLWriter writer) {
        this.writer = writer;
    }

    public void writeStartElement(URI elementName) {
        try {
            this.writer.writeStartElement(elementName.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeParseTypeAttribute() {
        try {
            this.writer.writeAttribute((Object)((Object)Namespaces.RDF) + "parseType", "Collection");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeDatatypeAttribute(URI datatypeURI) {
        try {
            this.writer.writeAttribute((Object)((Object)Namespaces.RDF) + "datatype", datatypeURI.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTextContent(String text) {
        try {
            this.writer.writeTextContent(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeLangAttribute(String lang) {
        try {
            this.writer.writeAttribute("xml:lang", lang);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEndElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeAboutAttribute(URI value) {
        this.writeAttribute((Object)((Object)Namespaces.RDF) + "about", value.toString());
    }

    private void writeAttribute(String attributeName, String value) {
        try {
            if (value.startsWith(this.writer.getXMLBase())) {
                this.writer.writeAttribute(attributeName, value.substring(this.writer.getXMLBase().length(), value.length()));
            } else {
                this.writer.writeAttribute(attributeName, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeOWLObject(OWLObject owlObject) {
    }

    public void writeResourceAttribute(URI value) {
        this.writeAttribute((Object)((Object)Namespaces.RDF) + "resource", value.toString());
    }

    public void startDocument() {
        try {
            this.writer.startDocument((Object)((Object)Namespaces.RDF) + "RDF");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void endDocument() {
        try {
            this.writer.endDocument();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeComment(String comment) {
        try {
            this.writer.writeComment(comment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

