/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdf.rdfxml;

import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owl.rdf.model.RDFLiteralNode;
import org.coode.owl.rdf.model.RDFNode;
import org.coode.owl.rdf.model.RDFResourceNode;
import org.coode.owl.rdf.model.RDFTriple;
import org.coode.owl.rdf.rdfxml.RDFXMLNamespaceManager;
import org.coode.owl.rdf.rdfxml.RDFXMLWriter;
import org.coode.owl.rdf.renderer.RDFRendererBase;
import org.coode.string.EscapeUtils;
import org.coode.xml.XMLWriterFactory;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class RDFXMLRenderer
extends RDFRendererBase {
    private RDFXMLWriter writer;
    private Set<RDFResourceNode> pending = new HashSet<RDFResourceNode>();

    public RDFXMLRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer w) {
        this(manager, ontology, w, manager.getOntologyFormat(ontology));
    }

    public RDFXMLRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer w, OWLOntologyFormat format) {
        super(ontology, manager, format);
        this.writer = new RDFXMLWriter(XMLWriterFactory.getInstance().createXMLWriter(w, new RDFXMLNamespaceManager(manager, ontology, format), ontology.getURI().toString()));
        this.prettyPrintedTypes = new HashSet();
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_CLASS.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_DATA_PROPERTY.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_RESTRICTION.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_THING.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NOTHING.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ONTOLOGY.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getURI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION.getURI());
    }

    protected void beginDocument() {
        this.writer.startDocument();
    }

    protected void endDocument() {
        this.writer.endDocument();
    }

    protected void writeIndividualComments(OWLIndividual ind) {
        this.writer.writeComment(EscapeUtils.escapeXML(ind.getURI().toString()));
    }

    protected void writeClassComment(OWLClass cls) {
        this.writer.writeComment(EscapeUtils.escapeXML(cls.getURI().toString()));
    }

    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writer.writeComment(EscapeUtils.escapeXML(prop.getURI().toString()));
    }

    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writer.writeComment(EscapeUtils.escapeXML(prop.getURI().toString()));
    }

    protected void writeBanner(String name) {
        this.writer.writeComment("\n///////////////////////////////////////////////////////////////////////////////////////\n//\n// " + name + "\n" + "//\n" + "///////////////////////////////////////////////////////////////////////////////////////\n");
    }

    public void render(RDFResourceNode node) {
        if (this.pending.contains(node)) {
            throw new IllegalStateException("Rendering cycle!  This indicates structure sharing and should not happen!");
        }
        this.pending.add(node);
        TreeSet<RDFTriple> triples = new TreeSet<RDFTriple>(new RDFRendererBase.TripleComparator());
        triples.addAll(this.getGraph().getTriplesForSubject(node));
        RDFTriple candidatePrettyPrintTypeTriple = null;
        for (RDFTriple triple : this.getGraph().getTriplesForSubject(node)) {
            URI propertyURI = triple.getProperty().getURI();
            if (!propertyURI.equals(OWLRDFVocabulary.RDF_TYPE.getURI()) || triple.getObject().isAnonymous()) continue;
            if (OWLRDFVocabulary.BUILT_IN_VOCABULARY.contains(triple.getObject().getURI())) {
                if (!this.prettyPrintedTypes.contains(triple.getObject().getURI())) continue;
                candidatePrettyPrintTypeTriple = triple;
                continue;
            }
            candidatePrettyPrintTypeTriple = triple;
        }
        if (candidatePrettyPrintTypeTriple == null) {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getURI());
        } else {
            this.writer.writeStartElement(candidatePrettyPrintTypeTriple.getObject().getURI());
        }
        if (!node.isAnonymous()) {
            this.writer.writeAboutAttribute(node.getURI());
        }
        for (RDFTriple triple : triples) {
            if (candidatePrettyPrintTypeTriple != null && candidatePrettyPrintTypeTriple.equals(triple)) continue;
            this.writer.writeStartElement(triple.getProperty().getURI());
            RDFNode objectNode = triple.getObject();
            if (!objectNode.isLiteral()) {
                RDFResourceNode objectRes = (RDFResourceNode)objectNode;
                if (objectRes.isAnonymous()) {
                    if (this.isObjectList(objectRes)) {
                        this.writer.writeParseTypeAttribute();
                        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                        this.toJavaList(objectRes, list);
                        for (RDFNode n : list) {
                            if (n.isAnonymous()) {
                                this.render((RDFResourceNode)n);
                                continue;
                            }
                            if (n.isLiteral()) {
                                RDFLiteralNode litNode = (RDFLiteralNode)n;
                                this.writer.writeStartElement(OWLRDFVocabulary.RDFS_LITERAL.getURI());
                                if (litNode.getDatatype() != null) {
                                    this.writer.writeDatatypeAttribute(litNode.getDatatype());
                                } else if (litNode.getLang() != null) {
                                    this.writer.writeLangAttribute(litNode.getLang());
                                }
                                this.writer.writeTextContent(litNode.getLiteral());
                                this.writer.writeEndElement();
                                continue;
                            }
                            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getURI());
                            this.writer.writeAboutAttribute(n.getURI());
                            this.writer.writeEndElement();
                        }
                    } else {
                        this.render(objectRes);
                    }
                } else {
                    this.writer.writeResourceAttribute(objectRes.getURI());
                }
            } else {
                RDFLiteralNode rdfLiteralNode = (RDFLiteralNode)objectNode;
                if (rdfLiteralNode.getDatatype() != null) {
                    this.writer.writeDatatypeAttribute(rdfLiteralNode.getDatatype());
                } else if (rdfLiteralNode.getLang() != null) {
                    this.writer.writeLangAttribute(rdfLiteralNode.getLang());
                }
                this.writer.writeTextContent(rdfLiteralNode.getLiteral());
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.pending.remove(node);
    }
}

