/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.net.URI;
import org.coode.owl.owlxmlparser.AbstractOWLDataRangeHandler;
import org.coode.owl.owlxmlparser.OWLConstantElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserElementNotFoundException;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;

public class OWLDataRestrictionElementHandler
extends AbstractOWLDataRangeHandler {
    private OWLDataRange dataRange;
    private OWLTypedConstant constant;
    private URI facetURI;

    public OWLDataRestrictionElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    public void handleChild(AbstractOWLDataRangeHandler handler) {
        this.dataRange = handler.getOWLObject();
    }

    public void handleChild(OWLConstantElementHandler handler) throws OWLXMLParserException {
        if (!handler.getOWLObject().isTyped()) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "typed constant in data range restriction");
        }
        this.constant = (OWLTypedConstant)handler.getOWLObject();
    }

    public void attribute(String localName, String value) throws OWLXMLParserException {
        super.attribute(localName, value);
        if (localName.equals("facet")) {
            this.facetURI = this.getURI(value);
        }
    }

    protected void endDataRangeElement() throws OWLXMLParserException {
        if (this.dataRange == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "data range element");
        }
        if (this.constant == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "typed constant element");
        }
        this.setDataRange(this.getOWLDataFactory().getOWLDataRangeRestriction(this.dataRange, OWLRestrictedDataRangeFacetVocabulary.getFacet(this.facetURI), this.constant));
    }
}

