/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owl.krssparser;

import de.uulm.ecs.ai.owl.krssparser.KRSS2OWLParserException;
import de.uulm.ecs.ai.owl.krssparser.KRSS2ParserConstants;
import de.uulm.ecs.ai.owl.krssparser.KRSS2ParserTokenManager;
import de.uulm.ecs.ai.owl.krssparser.ParseException;
import de.uulm.ecs.ai.owl.krssparser.SimpleCharStream;
import de.uulm.ecs.ai.owl.krssparser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLMutableOntology;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRSS2Parser
implements KRSS2ParserConstants {
    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, URI> string2URI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private String base;
    public KRSS2ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[53];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setOntology(OWLOntology ontology, OWLDataFactory dataFactory) {
        this.ontology = ontology;
        this.dataFactory = dataFactory;
        this.string2URI = new HashMap<String, URI>();
        this.base = ontology.getURI().toString() + "#";
    }

    protected void addAxiom(OWLAxiom ax) throws KRSS2OWLParserException {
        try {
            ((OWLMutableOntology)this.ontology).applyChange(new AddAxiom(this.ontology, ax));
        }
        catch (OWLOntologyChangeException e) {
            throw new KRSS2OWLParserException(e);
        }
    }

    protected static boolean isFileURI(URI uri) {
        URL url;
        if (!uri.isAbsolute()) {
            return false;
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return url.getProtocol().equals("file");
    }

    protected static String extractLocalname(URI uri) {
        if (uri.getFragment() != null && !uri.getFragment().equals("")) {
            return uri.getFragment();
        }
        String uriString = uri.toString();
        int index = -1;
        if (KRSS2Parser.isFileURI(uri)) {
            index = uriString.lastIndexOf("/");
            if (index < 0) {
                index = uriString.lastIndexOf("\\");
            }
        } else {
            index = uriString.indexOf("#");
        }
        if (++index > -1) {
            return uriString.substring(index, uriString.length());
        }
        return null;
    }

    public URI getURI(String s) throws URISyntaxException {
        URI uri;
        URI tmpURI = URI.create(s);
        String localName = KRSS2Parser.extractLocalname(tmpURI);
        if (localName != s) {
            s = this.base + s;
        }
        if ((uri = this.string2URI.get(s)) == null) {
            uri = new URI(s);
            this.string2URI.put(s, uri);
        }
        return uri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        this.ignoreAnnotationsAndDeclarations = b;
    }

    public final void parse() throws ParseException, KRSS2OWLParserException {
        while (this.jj_2_1(2)) {
            this.TBoxStatement();
        }
        if (this.jj_2_2(2)) {
            this.jj_consume_token(17);
        }
        while (this.jj_2_3(2)) {
            this.ABoxStatement();
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(18);
        }
        this.jj_consume_token(0);
    }

    public final void TBoxStatement() throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_5(2)) {
            this.DefinePrimitiveConcept();
        } else if (this.jj_2_6(2)) {
            this.DefineConcept();
        } else if (this.jj_2_7(2)) {
            this.DefinePrimitiveRole();
        } else if (this.jj_2_8(2)) {
            this.Transitive();
        } else if (this.jj_2_9(2)) {
            this.Range();
        } else if (this.jj_2_10(2)) {
            this.Implies();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void DefinePrimitiveConcept() throws ParseException, KRSS2OWLParserException {
        OWLDescription subClass = null;
        OWLDescription superClass = null;
        this.jj_consume_token(15);
        this.jj_consume_token(20);
        subClass = this.ConceptName();
        if (this.jj_2_11(2)) {
            superClass = this.ConceptExpression();
        }
        this.jj_consume_token(16);
        if (subClass instanceof OWLClass) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)subClass));
            if (superClass != null) {
                this.addAxiom(this.dataFactory.getOWLSubClassAxiom(subClass, superClass));
            }
        }
    }

    public final void DefineConcept() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(21);
        OWLDescription clsA = this.ConceptName();
        OWLDescription clsB = this.ConceptExpression();
        this.jj_consume_token(16);
        if (clsA instanceof OWLClass) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)clsA));
        }
        HashSet<OWLDescription> ops = new HashSet<OWLDescription>();
        ops.add(clsA);
        ops.add(clsB);
        this.addAxiom(this.dataFactory.getOWLEquivalentClassesAxiom(ops));
    }

    public final void DefinePrimitiveRole() throws ParseException, KRSS2OWLParserException {
        HashSet roles = new HashSet();
        HashSet descs = new HashSet();
        this.jj_consume_token(15);
        this.jj_consume_token(22);
        OWLObjectProperty subProp = this.RoleName();
        if (subProp != null) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom(subProp));
        }
        this.Parents(subProp);
        this.Domain(subProp);
        this.RangeAttribute(subProp);
        this.TransitiveAttribute(subProp);
        this.SymmetricAttribute(subProp);
        this.InverseProperty(subProp);
        this.jj_consume_token(16);
    }

    public final void InverseProperty(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_12(2)) {
            this.jj_consume_token(29);
            OWLObjectProperty superProp = this.RoleName();
            this.addAxiom(this.dataFactory.getOWLInverseObjectPropertiesAxiom(subProp, superProp));
        }
    }

    public final void Domain(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        if (this.jj_2_16(2)) {
            OWLDescription desc;
            this.jj_consume_token(28);
            if (this.jj_2_14(2)) {
                this.jj_consume_token(15);
                do {
                    if ((desc = this.ConceptExpression()) == null) continue;
                    descs.add(desc);
                } while (this.jj_2_13(2));
                this.jj_consume_token(16);
            } else if (this.jj_2_15(2)) {
                desc = this.ConceptExpression();
                descs.add(desc);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            for (OWLDescription eachDescription : descs) {
                this.addAxiom(this.dataFactory.getOWLObjectPropertyDomainAxiom(subProp, eachDescription));
                if (!(eachDescription instanceof OWLClass)) continue;
                this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)eachDescription));
            }
        }
    }

    public final void RangeAttribute(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        if (this.jj_2_20(2)) {
            OWLDescription desc;
            this.jj_consume_token(27);
            if (this.jj_2_18(2)) {
                this.jj_consume_token(15);
                do {
                    if ((desc = this.ConceptExpression()) == null) continue;
                    descs.add(desc);
                } while (this.jj_2_17(2));
                this.jj_consume_token(16);
            } else if (this.jj_2_19(2)) {
                desc = this.ConceptExpression();
                descs.add(desc);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            for (OWLDescription eachDescription : descs) {
                this.addAxiom(this.dataFactory.getOWLObjectPropertyRangeAxiom(subProp, eachDescription));
                if (!(eachDescription instanceof OWLClass)) continue;
                this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)eachDescription));
            }
        }
    }

    public final void TransitiveAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_23(2)) {
            this.jj_consume_token(25);
            if (this.jj_2_21(2)) {
                this.jj_consume_token(13);
            } else if (this.jj_2_22(2)) {
                this.jj_consume_token(14);
                this.addAxiom(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(property));
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SymmetricAttribute(OWLObjectProperty property) throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_26(2)) {
            this.jj_consume_token(26);
            if (this.jj_2_24(2)) {
                this.jj_consume_token(13);
            } else if (this.jj_2_25(2)) {
                this.jj_consume_token(14);
                this.addAxiom(this.dataFactory.getOWLSymmetricObjectPropertyAxiom(property));
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void Parents(OWLObjectProperty subProp) throws ParseException, KRSS2OWLParserException {
        if (!this.jj_2_33(2)) return;
        if (this.jj_2_31(2)) {
            this.jj_consume_token(32);
            if (this.jj_2_27(2)) {
                this.jj_consume_token(13);
                return;
            }
            if (!this.jj_2_28(2)) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(15);
            Set<OWLObjectProperty> roles = this.RoleNameSet();
            this.jj_consume_token(16);
            if (roles == null) return;
            Iterator<OWLObjectProperty> i$ = roles.iterator();
            while (i$.hasNext()) {
                OWLObjectProperty prop = i$.next();
                this.addAxiom(this.dataFactory.getOWLSubObjectPropertyAxiom(subProp, prop));
                if (!(prop instanceof OWLObjectProperty)) continue;
                this.addAxiom(this.dataFactory.getOWLDeclarationAxiom(prop));
            }
            return;
        }
        if (!this.jj_2_32(2)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(33);
        if (this.jj_2_29(2)) {
            this.jj_consume_token(13);
            return;
        }
        if (this.jj_2_30(2)) {
            OWLObjectProperty superProp = this.RoleName();
            this.addAxiom(this.dataFactory.getOWLSubObjectPropertyAxiom(subProp, superProp));
            if (!(superProp instanceof OWLClass)) return;
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom(superProp));
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Implies() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(48);
        OWLDescription subDescription = this.ConceptExpression();
        OWLDescription superDescription = this.ConceptExpression();
        this.jj_consume_token(16);
        this.addAxiom(this.dataFactory.getOWLSubClassAxiom(subDescription, superDescription));
        if (subDescription instanceof OWLClass) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)subDescription));
        }
        if (superDescription instanceof OWLClass) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)superDescription));
        }
    }

    public final void Transitive() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(24);
        OWLObjectProperty prop = this.RoleName();
        this.jj_consume_token(16);
        this.addAxiom(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop));
    }

    public final void Range() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(35);
        OWLObjectProperty prop = this.RoleName();
        OWLDescription rng = this.ConceptExpression();
        this.jj_consume_token(16);
        this.addAxiom(this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng));
        if (prop instanceof OWLObjectProperty) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom(prop));
        }
        if (rng instanceof OWLClass) {
            this.addAxiom(this.dataFactory.getOWLDeclarationAxiom((OWLClass)rng));
        }
    }

    public final OWLDescription ConceptExpression() throws ParseException, KRSS2OWLParserException {
        OWLDescription desc;
        if (this.jj_2_34(2)) {
            desc = this.ConceptName();
        } else if (this.jj_2_35(2)) {
            desc = this.And();
        } else if (this.jj_2_36(2)) {
            desc = this.Or();
        } else if (this.jj_2_37(2)) {
            desc = this.Not();
        } else if (this.jj_2_38(2)) {
            desc = this.All();
        } else if (this.jj_2_39(2)) {
            desc = this.Some();
        } else if (this.jj_2_40(2)) {
            desc = this.AtLeast();
        } else if (this.jj_2_41(2)) {
            desc = this.AtMost();
        } else if (this.jj_2_42(2)) {
            desc = this.Exactly();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLDescription ConceptName() throws ParseException, KRSS2OWLParserException {
        URI uri = this.Name();
        return this.dataFactory.getOWLClass(uri);
    }

    public final Set<OWLDescription> ConceptSet() throws ParseException, KRSS2OWLParserException {
        HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
        do {
            OWLDescription desc = this.ConceptExpression();
            descs.add(desc);
        } while (this.jj_2_43(2));
        return descs;
    }

    public final OWLDescription And() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(36);
        Set<OWLDescription> operands = this.ConceptSet();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectIntersectionOf(operands);
    }

    public final OWLDescription Or() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(37);
        Set<OWLDescription> operands = this.ConceptSet();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectUnionOf(operands);
    }

    public final OWLDescription Not() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(38);
        OWLDescription operand = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectComplementOf(operand);
    }

    public final OWLDescription All() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(39);
        OWLObjectProperty prop = this.RoleName();
        OWLDescription filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectAllRestriction(prop, filler);
    }

    public final OWLDescription Some() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(40);
        OWLObjectProperty prop = this.RoleName();
        OWLDescription filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectSomeRestriction(prop, filler);
    }

    public final OWLDescription AtLeast() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(41);
        int card = this.Integer();
        OWLObjectProperty prop = this.RoleName();
        OWLDescription filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, card, filler);
    }

    public final OWLDescription AtMost() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(42);
        int card = this.Integer();
        OWLObjectProperty prop = this.RoleName();
        OWLDescription filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, card, filler);
    }

    public final OWLDescription Exactly() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(43);
        int card = this.Integer();
        OWLObjectProperty prop = this.RoleName();
        OWLDescription filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, card, filler);
    }

    public final OWLObjectProperty RoleName() throws ParseException, KRSS2OWLParserException {
        URI uri = this.Name();
        if (uri == null) {
            return null;
        }
        return this.dataFactory.getOWLObjectProperty(uri);
    }

    public final Set<OWLObjectProperty> RoleNameSet() throws ParseException, KRSS2OWLParserException {
        HashSet<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
        do {
            OWLObjectProperty role = this.RoleName();
            roles.add(role);
        } while (this.jj_2_44(2));
        return roles;
    }

    public final void ABoxStatement() throws ParseException, KRSS2OWLParserException {
        if (this.jj_2_45(2)) {
            this.Instance();
        } else if (this.jj_2_46(2)) {
            this.Related();
        } else if (this.jj_2_47(2)) {
            this.Equal();
        } else if (this.jj_2_48(2)) {
            this.Distinct();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void Instance() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(44);
        OWLIndividual ind = this.IndividualName();
        OWLDescription type = this.ConceptExpression();
        this.jj_consume_token(16);
        this.addAxiom(this.dataFactory.getOWLClassAssertionAxiom(ind, type));
    }

    public final void Related() throws ParseException, KRSS2OWLParserException {
        this.jj_consume_token(15);
        this.jj_consume_token(45);
        OWLIndividual subj = this.IndividualName();
        OWLObjectProperty prop = this.RoleName();
        OWLIndividual obj = this.IndividualName();
        this.jj_consume_token(16);
        this.addAxiom(this.dataFactory.getOWLObjectPropertyAssertionAxiom(subj, prop, obj));
    }

    public final void Equal() throws ParseException, KRSS2OWLParserException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(15);
        this.jj_consume_token(46);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(16);
        inds.add(indA);
        inds.add(indB);
        this.addAxiom(this.dataFactory.getOWLSameIndividualsAxiom(inds));
    }

    public final void Distinct() throws ParseException, KRSS2OWLParserException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(15);
        this.jj_consume_token(47);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(16);
        inds.add(indA);
        inds.add(indB);
        this.addAxiom(this.dataFactory.getOWLDifferentIndividualsAxiom(inds));
    }

    public final OWLIndividual IndividualName() throws ParseException, KRSS2OWLParserException {
        URI name = this.Name();
        return this.dataFactory.getOWLIndividual(name);
    }

    public final int Integer() throws ParseException, KRSS2OWLParserException {
        Token t = this.jj_consume_token(49);
        return Integer.parseInt(t.image);
    }

    public final boolean parseBoolean() throws ParseException {
        if (this.jj_2_49(2)) {
            this.jj_consume_token(14);
            return true;
        }
        if (this.jj_2_50(2)) {
            this.jj_consume_token(13);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final URI Name() throws ParseException {
        if (this.jj_2_51(2)) {
            Token t = this.jj_consume_token(11);
            return OWLRDFVocabulary.OWL_THING.getURI();
        }
        if (this.jj_2_52(2)) {
            Token t = this.jj_consume_token(12);
            return OWLRDFVocabulary.OWL_NOTHING.getURI();
        }
        if (!this.jj_2_53(2)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        Token t = this.jj_consume_token(50);
        return URI.create(t.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private final boolean jj_3_1() {
        return this.jj_3R_7();
    }

    private final boolean jj_3_32() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_30()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_15() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_14() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_45() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_46()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_47()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_48()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_28() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private final boolean jj_3_44() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_17() {
        Token xsp;
        if (this.jj_3_44()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_44());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_27() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_31() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_28()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_42() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_31();
    }

    private final boolean jj_3_25() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(43);
    }

    private final boolean jj_3_24() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3_22() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_41() {
        return this.jj_3R_25();
    }

    private final boolean jj_3_21() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3_52() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(42);
    }

    private final boolean jj_3_17() {
        return this.jj_3R_15();
    }

    private final boolean jj_3_40() {
        return this.jj_3R_24();
    }

    private final boolean jj_3_26() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_25()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private final boolean jj_3_18() {
        Token xsp;
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_17());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_23() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_13() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_23() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(40);
    }

    private final boolean jj_3_39() {
        return this.jj_3R_23();
    }

    private final boolean jj_3_14() {
        Token xsp;
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_13());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_10() {
        return this.jj_3R_14();
    }

    private final boolean jj_3_20() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_19()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_22() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private final boolean jj_3_38() {
        return this.jj_3R_22();
    }

    private final boolean jj_3_50() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3_9() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private final boolean jj_3_37() {
        return this.jj_3R_21();
    }

    private final boolean jj_3_53() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3_16() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_51() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_52()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_53()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_20() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(37);
    }

    private final boolean jj_3_11() {
        return this.jj_3R_15();
    }

    private final boolean jj_3_8() {
        return this.jj_3R_12();
    }

    private final boolean jj_3_36() {
        return this.jj_3R_20();
    }

    private final boolean jj_3R_19() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private final boolean jj_3_49() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private final boolean jj_3_43() {
        return this.jj_3R_15();
    }

    private final boolean jj_3_35() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_11() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private final boolean jj_3_7() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_4() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_31();
    }

    private final boolean jj_3_34() {
        return this.jj_3R_18();
    }

    private final boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_36()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_37()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_38()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_39()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_40()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_41()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_42()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(47);
    }

    private final boolean jj_3_6() {
        return this.jj_3R_10();
    }

    private final boolean jj_3R_10() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_8();
    }

    private final boolean jj_3_48() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_13() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_9() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3_47() {
        return this.jj_3R_29();
    }

    private final boolean jj_3_30() {
        return this.jj_3R_16();
    }

    private final boolean jj_3_19() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(45);
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private final boolean jj_3_29() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3_5() {
        return this.jj_3R_9();
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_7()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_8()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_9()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_10()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_46() {
        return this.jj_3R_28();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[0];
    }

    public KRSS2Parser(InputStream stream) {
        this(stream, null);
    }

    public KRSS2Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new KRSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public KRSS2Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new KRSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public KRSS2Parser(KRSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(KRSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[53];
        for (i = 0; i < 53; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 53; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 53; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        KRSS2Parser.jj_la1_0();
        KRSS2Parser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

