/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import com.clarkparsia.explanation.MultipleExplanationGenerator;
import com.clarkparsia.explanation.ReasonerFactory;
import com.clarkparsia.explanation.SingleExplanationGenerator;
import com.clarkparsia.explanation.util.ExplanationProgressMonitor;
import com.clarkparsia.explanation.util.OntologyUtils;
import com.clarkparsia.explanation.util.SilentExplanationProgressMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSTExplanationGenerator
implements MultipleExplanationGenerator {
    public static final Logger log = Logger.getLogger(HSTExplanationGenerator.class.getName());
    private SingleExplanationGenerator singleExplanationGenerator;
    private ExplanationProgressMonitor progressMonitor = new SilentExplanationProgressMonitor();

    public HSTExplanationGenerator(SingleExplanationGenerator singleExplanationGenerator) {
        this.singleExplanationGenerator = singleExplanationGenerator;
    }

    @Override
    public void setProgressMonitor(ExplanationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    @Override
    public OWLOntologyManager getOntologyManager() {
        return this.singleExplanationGenerator.getOntologyManager();
    }

    @Override
    public OWLOntology getOntology() {
        return this.singleExplanationGenerator.getOntology();
    }

    @Override
    public void setOntology(OWLOntology ontology) {
        this.singleExplanationGenerator.setOntology(ontology);
    }

    @Override
    public OWLClassReasoner getReasoner() {
        return this.singleExplanationGenerator.getReasoner();
    }

    @Override
    public void setReasoner(OWLClassReasoner reasoner) {
        this.singleExplanationGenerator.setReasoner(reasoner);
    }

    @Override
    public ReasonerFactory getReasonerFactory() {
        return this.singleExplanationGenerator.getReasonerFactory();
    }

    @Override
    public void setReasonerFactory(ReasonerFactory reasonerFactory) {
        this.singleExplanationGenerator.setReasonerFactory(reasonerFactory);
    }

    public SingleExplanationGenerator getSingleExplanationGenerator() {
        return this.singleExplanationGenerator;
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLDescription unsatClass) {
        return this.singleExplanationGenerator.getExplanation(unsatClass);
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLDescription unsatClass) {
        return this.getExplanations(unsatClass, 0);
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLDescription unsatClass, int maxExplanations) {
        if (maxExplanations < 0) {
            throw new IllegalArgumentException();
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Get " + (maxExplanations == 0 ? "all" : Integer.valueOf(maxExplanations)) + " explanation(s) for: " + unsatClass);
        }
        try {
            Set<OWLAxiom> firstMups = this.getExplanation(unsatClass);
            if (firstMups.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<Set<OWLAxiom>> allMups = new LinkedHashSet<Set<OWLAxiom>>();
            this.progressMonitor.foundExplanation(firstMups);
            allMups.add(firstMups);
            HashSet<Set<OWLAxiom>> satPaths = new HashSet<Set<OWLAxiom>>();
            HashSet<OWLAxiom> currentPathContents = new HashSet<OWLAxiom>();
            this.constructHittingSetTree(unsatClass, firstMups, allMups, satPaths, currentPathContents, maxExplanations);
            this.progressMonitor.foundAllExplanations();
            return allMups;
        }
        catch (OWLException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private static List<OWLAxiom> getOrderedMUPS(List<OWLAxiom> mups, final Set<Set<OWLAxiom>> allMups) {
        Comparator<OWLAxiom> mupsComparator = new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                int occ1 = HSTExplanationGenerator.getOccurrences(o1, allMups);
                int occ2 = HSTExplanationGenerator.getOccurrences(o2, allMups);
                return -occ1 + occ2;
            }
        };
        Collections.sort(mups, mupsComparator);
        return mups;
    }

    private static int getOccurrences(OWLAxiom ax, Set<Set<OWLAxiom>> axiomSets) {
        int count = 0;
        for (Set<OWLAxiom> axioms : axiomSets) {
            if (!axioms.contains(ax)) continue;
            ++count;
        }
        return count;
    }

    private void constructHittingSetTree(OWLDescription unsatClass, Set<OWLAxiom> mups, Set<Set<OWLAxiom>> allMups, Set<Set<OWLAxiom>> satPaths, Set<OWLAxiom> currentPathContents, int maxExplanations) throws OWLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MUPS " + allMups.size() + ": " + mups);
        }
        if (this.progressMonitor.isCancelled()) {
            return;
        }
        List<OWLAxiom> orderedMups = HSTExplanationGenerator.getOrderedMUPS(new ArrayList<OWLAxiom>(mups), allMups);
        while (!orderedMups.isEmpty()) {
            if (this.progressMonitor.isCancelled()) {
                return;
            }
            OWLAxiom axiom = orderedMups.get(0);
            orderedMups.remove(0);
            if (allMups.size() == maxExplanations) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Computed " + maxExplanations + "explanations");
                }
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removing axiom: " + axiom + " " + currentPathContents.size() + " more removed: " + currentPathContents);
            }
            Set<OWLOntology> ontologies = OntologyUtils.removeAxiom(axiom, this.getReasoner().getLoadedOntologies(), this.getOntologyManager());
            currentPathContents.add(axiom);
            boolean earlyTermination = false;
            for (Set<OWLAxiom> satPath : satPaths) {
                if (!currentPathContents.containsAll(satPath)) continue;
                earlyTermination = true;
                if (!log.isLoggable(Level.FINE)) break;
                log.fine("Stop - satisfiable (early termination)");
                break;
            }
            if (!earlyTermination) {
                Set<OWLAxiom> newMUPS = null;
                for (Set<OWLAxiom> foundMUPS : allMups) {
                    HashSet<OWLAxiom> foundMUPSCopy = new HashSet<OWLAxiom>(foundMUPS);
                    foundMUPSCopy.retainAll(currentPathContents);
                    if (!foundMUPSCopy.isEmpty()) continue;
                    newMUPS = foundMUPS;
                    break;
                }
                if (newMUPS == null) {
                    newMUPS = this.getExplanation(unsatClass);
                }
                if (newMUPS.contains(axiom)) {
                    throw new OWLRuntimeException("Explanation contains removed axiom: " + axiom);
                }
                if (!newMUPS.isEmpty()) {
                    allMups.add(newMUPS);
                    this.progressMonitor.foundExplanation(newMUPS);
                    this.constructHittingSetTree(unsatClass, newMUPS, allMups, satPaths, currentPathContents, maxExplanations);
                    orderedMups = HSTExplanationGenerator.getOrderedMUPS(orderedMups, allMups);
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Stop - satisfiable");
                    }
                    satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
                }
            }
            currentPathContents.remove(axiom);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Restoring axiom: " + axiom);
            }
            OntologyUtils.addAxiom(axiom, ontologies, this.getOntologyManager());
        }
    }
}

